package gov.va.med.mhv.admin.service.mhvusers;

import gov.va.med.mhv.admin.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.admin.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.admin.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;

public interface ActivityService {
	
	/**
	 * Audits MVI Match & Correlation Event
	 *
	 * @param userProfile
	 * @param actor
	 * @param successful
	 * @param activityActionType
	 * @param activityType
	 * @param response
	 */
	public void auditMviEvent(
		UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ActivityActionTypeEnumeration activityActionType,
		ActivityTypeEnumeration activityType, ResponseUtil response);

	public void auditAccountDeactivateEauthHashEvent(UserProfileDTO userProfile, ResponseUtil response);
	
	public void auditAccountDeactivateEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response) ;
	
	public void auditUpdateProfileEvent(Long userProfileId, ActivityActorTypeEnumeration actor, ResponseUtil response);
	
	public void auditAccountReactivateEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response) ;
	
	public void auditMviUnauthenticateRequestEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);
	
	public void auditMviCorrelateEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);
	
	public void auditMviAuthenticateEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, String facilityName, ResponseUtil response);
	
	public void auditMviUnauthenticateEvent(UserProfileDTO userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response);
			
}